<?php
/*--------------------------------------------------------------------
 OnGetSellingUnitModelEvent.php 2020-06-24
 Gambio GmbH
 http://www.gambio.de
 Copyright (c) 2020 Gambio GmbH
 Released under the GNU General Public License (Version 2)
 [http://www.gnu.org/licenses/gpl-2.0.html]
 -------------------------------------------------------------------*/

declare(strict_types=1);

namespace Gambio\Shop\SellingUnit\Database\Unit\Events;

use Gambio\Shop\Language\ValueObjects\LanguageId;
use Gambio\Shop\Product\ValueObjects\ProductId;
use Gambio\Shop\ProductModifiers\Modifiers\Collections\ModifierIdentifierCollectionInterface;
use Gambio\Shop\Properties\Properties\ValueObjects\CombinationId;
use Gambio\Shop\SellingUnit\Database\Unit\Events\Interfaces\OnGetSellingUnitModelEventInterface;
use Gambio\Shop\SellingUnit\Unit\ValueObjects\Model;
use ProductDataInterface;

/**
 * Class OnGetSellingUnitModelEvent
 * @package Gambio\Shop\SellingUnit\Database\Unit\Events
 */
class OnGetSellingUnitModelEvent extends OnGetProductModelEvent implements OnGetSellingUnitModelEventInterface
{
    /**
     * OnGetSellingUnitModelEvent constructor.
     *
     * @param ProductDataInterface                  $product
     * @param ProductId                             $productId
     * @param ModifierIdentifierCollectionInterface $modifiers
     * @param LanguageId                            $languageId
     * @param Model                                 $model
     * @param CombinationId|null                    $combinationId
     */
    public function __construct(
        ProductDataInterface $product,
        ProductId $productId,
        ModifierIdentifierCollectionInterface $modifiers,
        LanguageId $languageId,
        Model $model,
        ?CombinationId $combinationId = null
    ) {
        $this->product       = $product;
        $this->productId     = $productId;
        $this->modifiers     = $modifiers;
        $this->languageId    = $languageId;
        $this->model         = $model;
        $this->combinationId = $combinationId;
    }
}